/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.screen;

import com.alexander.mutantmore.patron_pet.PatronPetUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenPatronPetScreenPacket {
    private final boolean shouldSpawnParticles;
    private final boolean active;
    private final boolean playAudio;

    public OpenPatronPetScreenPacket(boolean shouldSpawnParticles, boolean active, boolean playAudio) {
        this.shouldSpawnParticles = shouldSpawnParticles;
        this.active = active;
        this.playAudio = active;
    }

    public OpenPatronPetScreenPacket(FriendlyByteBuf buf) {
        this.shouldSpawnParticles = buf.readBoolean();
        this.active = buf.readBoolean();
        this.playAudio = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.shouldSpawnParticles);
        buf.writeBoolean(this.active);
        buf.writeBoolean(this.playAudio);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> PatronPetUtils.displayPatronPetGUI(this.shouldSpawnParticles, this.active, this.playAudio));
        return true;
    }
}

